/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import panther.util.general.ErrorUtils;
import panther.util.resource.ActionFailureException;
import panther.util.resource.ConnectionFactory;
import panther.util.resource.Resource;
import panther.util.resource.ResourceFactory;
import panther.util.resource.ResourceLog;
import panther.util.resource.ResourcePool;
import panther.util.resource.ResourcePoolConfiguration;
import panther.util.resource.ResourceUnavailableException;
import panther.util.smalltalk.SimpleBlock;
import panther.util.unicon.DeadlockAvoidanceException;
import panther.util.unicon.DeadlockAvoidingStack;
import panther.util.unicon.FeederThread;
import panther.util.unicon.GuaranteedAction;
import panther.util.unicon.GuaranteedActionLiberal;
import panther.util.unicon.GuaranteedActionStrict;
import panther.util.unicon.QueueThread;
import panther.util.unicon.SynchronizedCollection;
import panther.util.unicon.SynchronizedQueue;
import panther.util.unicon.SynchronizedSet;
import panther.util.unicon.SynchronizedStack;
import panther.util.unicon.ThreadUtil;
import panther.util.unicon.TimerThread;
import panther.util.unicon.UniconThread;

public class ResourcePoolBasic
implements ResourcePool {
    protected SynchronizedCollection allocatedResources;
    protected QueueThread timeoutThread;
    protected ResourcePoolConfiguration config;
    protected SynchronizedCollection createResources;
    protected QueueThread createThread;
    protected SynchronizedCollection deadResources;
    protected QueueThread destroyThread;
    protected SynchronizedCollection freeResources;
    protected ResourceLog log;
    protected SynchronizedCollection recycleResources;
    protected Set recycleThreads = new HashSet();
    protected ResourceFactory resourceFactory;
    protected UniconThread sizeThread;
    protected SynchronizedCollection spareTokens;
    protected boolean useGuaranteedActions;

    public ResourcePoolBasic(ResourcePoolConfiguration resourcePoolConfiguration, ResourceFactory resourceFactory) {
        this.config = resourcePoolConfiguration;
        this.resourceFactory = resourceFactory;
        this.log = new ResourceLog(resourcePoolConfiguration.getLogConfig());
        this.useGuaranteedActions = resourcePoolConfiguration.useGuaranteedActions();
        this.initializeResources(resourcePoolConfiguration.getMinSize(), resourcePoolConfiguration.getMaxSize());
        this.initializeThreads();
    }

    public Resource allocate(String string) throws ResourceUnavailableException {
        GuaranteedActionStrict guaranteedActionStrict = null;
        this.makeCapacity();
        this.log.log(5, this.getName() + " begin allocate");
        long l = System.currentTimeMillis();
        Resource resource = null;
        while (resource == null) {
            try {
                resource = (Resource)this.freeResources.next();
            }
            catch (DeadlockAvoidanceException deadlockAvoidanceException) {
                if (this.size() == this.allocatedSize() && this.spareTokens.size() == 0) {
                    throw deadlockAvoidanceException;
                }
                this.makeCapacity();
            }
            catch (InterruptedException interruptedException) {
                throw new ResourceUnavailableException(interruptedException);
            }
        }
        final Resource resource2 = resource;
        try {
            this.log.time(5, this, l, "allocate", "wait", string + " --> " + resource2.shortString(), this.config.getAllocationWaitWarnTime());
            if (this.useGuaranteedActions) {
                SimpleBlock simpleBlock = new SimpleBlock(){

                    public Object evaluate() throws Exception {
                        resource2.verify();
                        return null;
                    }
                };
                guaranteedActionStrict = new GuaranteedActionStrict("verify " + resource2, this.config.getVerifyLimit(), simpleBlock, false);
                guaranteedActionStrict.run();
                if (!guaranteedActionStrict.isSuccessful()) {
                    this.showError("verify", guaranteedActionStrict);
                    throw new ActionFailureException(guaranteedActionStrict.getThrowable());
                }
            }
            this.log.time(4, this, l, "allocate", "end", resource2, this.config.getAllocationWarnTime());
            this.log.time(5, this, l, "allocate", "bonus", this.asMessage(resource2));
            resource2.assign(string);
            this.allocatedResources.add(resource2);
        }
        catch (ActionFailureException actionFailureException) {
            this.createResources.add(resource2);
            this.log.error(this, actionFailureException);
            return this.allocate(string);
        }
        catch (Throwable throwable) {
            this.createResources.add(resource2);
            this.log.error(this, throwable);
            throw new ResourceUnavailableException(throwable);
        }
        if (this.isUsedUp(resource2)) {
            this.move(this.spareTokens, this.createResources);
        }
        return resource2;
    }

    protected void showError(String string, GuaranteedAction guaranteedAction) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Guaranteed Action Failure on ");
            stringBuffer.append(string);
            stringBuffer.append("\n\taction = ");
            stringBuffer.append(guaranteedAction);
            if (guaranteedAction != null) {
                stringBuffer.append("\n\treturn value = ");
                stringBuffer.append(guaranteedAction.getReturnValue());
                stringBuffer.append("\n\terroredOut = ");
                stringBuffer.append(guaranteedAction.erroredOut());
                stringBuffer.append("\n\tinterrupted = ");
                stringBuffer.append(guaranteedAction.interrupted());
                stringBuffer.append("\n\ttimedOut = ");
                stringBuffer.append(guaranteedAction.timedOut());
                Throwable throwable = guaranteedAction.getThrowable();
                if (throwable != null) {
                    stringBuffer.append("\n\tthrowable class =");
                    stringBuffer.append(throwable.getClass().getName());
                    stringBuffer.append("\n\tthrowable message = ");
                    stringBuffer.append(throwable.getMessage());
                }
            }
            this.log.log(0, stringBuffer.toString());
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
        }
    }

    public int allocatedSize() {
        return this.allocatedResources.size();
    }

    public void error(Object object, Throwable throwable) {
        this.log.error(this, object, throwable);
    }

    public int freeSize() {
        return this.freeResources.size();
    }

    public List getAllocationInfo() {
        List list = this.allocatedResources.contents();
        ArrayList arrayList = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>(6);
            Resource resource = (Resource)list.get(i);
            arrayList2.add(resource.getRawResourceID());
            arrayList2.add(resource.getRequester());
            arrayList2.add(new Long(resource.getAssignmentTime()));
            arrayList2.add(new Long(resource.getLastUseTime()));
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public ResourcePoolConfiguration getConfig() {
        return this.config;
    }

    public String getDescriptor() {
        return this.config.getDescriptor();
    }

    public int getLoginTimeout() {
        return this.config.getLoginTimeout();
    }

    public String getName() {
        return this.config.getName();
    }

    public ResourceLog getResourceLog() {
        return this.log;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release(Resource resource) {
        this.log.time(4, this, resource.getAssignmentTime(), "release", "", resource);
        resource.release();
        if (this.isDiscardable(resource)) {
            try {
                if (!this.move("release", resource, this.allocatedResources, this.deadResources)) return;
                this.addSpareToken();
                return;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Potential connection leak!", throwable);
            }
        } else {
            this.recreateResource("release", resource, this.allocatedResources, this.config.useRecycleQueue() ? this.recycleResources : this.freeResources);
        }
    }

    public void reportStats() {
    }

    public void setLoginTimeout(int n) {
        this.config.setLoginTimeout(n);
    }

    public int size() {
        return this.allocatedResources.size() + this.freeResources.size() + this.createResources.size() + this.recycleResources.size();
    }

    private void addSpareToken() {
        this.spareTokens.add(Resource.createEmptyResource(this));
    }

    private void initializeResources(int n, int n2) {
        int n3;
        this.allocatedResources = new SynchronizedSet();
        this.allocatedResources.setMaxSize(this.config.getMaxSize());
        this.createResources = new SynchronizedQueue();
        this.createResources.setMaxSize(this.config.getMaxSize());
        this.deadResources = new SynchronizedQueue();
        this.spareTokens = new SynchronizedQueue();
        this.spareTokens.setMaxSize(this.config.getMaxSize());
        this.freeResources = this.config.useDeadlockAvoidance() ? new DeadlockAvoidingStack(this.config.getMaxAllocationWaitTime()) : new SynchronizedStack(this.config.getMaxAllocationWaitTime());
        this.recycleResources = new SynchronizedQueue();
        for (n3 = 0; n3 < n; ++n3) {
            this.freeResources.add(this.resourceFactory.createResource(this, "ResourcePool"));
        }
        for (n3 = 0; n3 < n2 - n; ++n3) {
            this.addSpareToken();
        }
        if (this.config.useDeadlockAvoidance()) {
            ((DeadlockAvoidingStack)this.freeResources).resetResourceCount();
        }
    }

    private void initializeThreads() {
        this.useCreateThread();
        this.useDestroyThread();
        if (this.config.getDestroyThreadRecycleTime() > 0) {
            this.useRecycleDestroyThread();
        }
        if (this.config.useRecycleQueue()) {
            this.useRecycleThread();
        }
        this.useTimeoutThread();
        if (this.config.getSizeSleepTime() > 0) {
            this.useSizeThread();
        }
    }

    private boolean isDiscardable(Resource resource) {
        if (this.config.getMaxUsageCount() > 0 && resource.getUsageCount() < this.config.getMaxUsageCount()) {
            return false;
        }
        return this.freeResources.size() >= this.config.getMinSize();
    }

    private boolean isUsedUp(Resource resource) {
        if (this.config.getMaxUsageCount() <= 0) {
            return false;
        }
        return resource.getUsageCount() >= this.config.getMaxUsageCount();
    }

    private void makeCapacity() {
        if (this.freeResources.isEmpty()) {
            this.move(this.spareTokens, this.createResources);
            Thread.yield();
        }
    }

    protected String asMessage(Object object) {
        String string = "";
        if (this.config.getTraceCallers() > 0) {
            StringBuffer stringBuffer = new StringBuffer(object.toString());
            stringBuffer.append("\n\tCalled by:\n");
            List list = ThreadUtil.getSenders(1, this.config.getTraceCallers());
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append("\t\t");
                stringBuffer.append(list.get(i));
                stringBuffer.append("\n");
            }
            string = stringBuffer.toString();
        } else {
            string = object.toString();
        }
        return string;
    }

    protected void guaranteedCreate(Resource resource) {
        Resource resource2 = Resource.createEmptyResource(this);
        try {
            this.deadResources.add(resource);
            this.log.log(5, this, "create", "begin", null);
            long l = System.currentTimeMillis();
            if (!this.useGuaranteedActions) {
                resource2 = this.resourceFactory.createResource(this, "ResourcePool");
            } else {
                SimpleBlock simpleBlock = new SimpleBlock(){

                    public Object evaluate() throws Exception {
                        return ResourcePoolBasic.this.resourceFactory.createResource(ResourcePoolBasic.this, "ResourcePool");
                    }
                };
                GuaranteedActionLiberal guaranteedActionLiberal = new GuaranteedActionLiberal("create ", this.config.getCreateLimit(), simpleBlock, true);
                guaranteedActionLiberal.run();
                if (!guaranteedActionLiberal.isSuccessful()) {
                    this.showError("create", guaranteedActionLiberal);
                    throw new ActionFailureException(guaranteedActionLiberal.getThrowable());
                }
                resource2 = (Resource)guaranteedActionLiberal.getReturnValue();
                this.log(guaranteedActionLiberal, "create", (Resource)guaranteedActionLiberal.getReturnValue());
            }
            this.log.time(4, this, l, "create", "end", resource2, this.config.getCreationWarnTime());
            this.log.log(5, this, "create", "finally", null);
            this.freeResources.add(resource2);
        }
        catch (Throwable throwable) {
            this.createResources.add(resource2);
            this.log.error(this, throwable);
            throw new RuntimeException(throwable);
        }
    }

    protected void guaranteedDestroy(final Resource resource) {
        this.log.log(5, this, "destroy", "begin", resource);
        long l = System.currentTimeMillis();
        if (!this.useGuaranteedActions) {
            try {
                resource.destroy();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        } else {
            SimpleBlock simpleBlock = new SimpleBlock(){

                public Object evaluate() throws Exception {
                    resource.destroy();
                    return null;
                }
            };
            GuaranteedActionLiberal guaranteedActionLiberal = new GuaranteedActionLiberal("destroy " + resource, this.config.getDestroyLimit(), simpleBlock, true);
            guaranteedActionLiberal.run();
            this.log(guaranteedActionLiberal, "destroy", resource);
        }
        this.log.time(5, this, l, "destroy", "end", resource);
    }

    protected void guaranteedRecycle(final Resource resource) {
        try {
            this.log.log(5, this, "recycle", "begin", resource);
            long l = System.currentTimeMillis();
            if (!this.useGuaranteedActions) {
                resource.recycle();
            } else {
                SimpleBlock simpleBlock = new SimpleBlock(){

                    public Object evaluate() throws Exception {
                        resource.recycle();
                        return null;
                    }
                };
                GuaranteedActionStrict guaranteedActionStrict = new GuaranteedActionStrict("recycle " + resource, this.config.getRecycleLimit(), simpleBlock, true);
                guaranteedActionStrict.run();
                if (!guaranteedActionStrict.isSuccessful()) {
                    this.showError("recycle", guaranteedActionStrict);
                    throw new ActionFailureException(guaranteedActionStrict.getThrowable());
                }
            }
            this.log.time(5, this, l, "recycle", "end", resource, this.config.getRecycleWarnTime());
            this.freeResources.add(resource);
        }
        catch (Throwable throwable) {
            this.createResources.add(resource);
            this.log.error(this, throwable);
            throw new RuntimeException(throwable);
        }
    }

    protected void guaranteedTimeout(Resource resource) {
        this.log.log(4, this, "timeout", "", resource);
        this.log.log(0, this, "resource timeout", "ALERT", resource);
        if (this.recreateResource("timeout", resource, this.allocatedResources, this.createResources)) {
            resource.timeout();
        }
    }

    protected void log(GuaranteedAction guaranteedAction, String string, Resource resource) {
        this.log(3, guaranteedAction, string, resource);
    }

    protected void log(int n, GuaranteedAction guaranteedAction, String string, Resource resource) {
        if (guaranteedAction.timedOut()) {
            this.log.log(n, this, string, "timeout", resource);
        } else if (guaranteedAction.erroredOut()) {
            ErrorUtils.swallow(guaranteedAction.getThrowable());
            this.log.log(n, this, string, "error", resource + " --> " + guaranteedAction.getThrowable());
        } else if (guaranteedAction.interrupted()) {
            this.log.log(n, this, string, "interrupted", resource);
        }
    }

    protected boolean move(String string, Resource resource, SynchronizedCollection synchronizedCollection, SynchronizedCollection synchronizedCollection2) {
        return this.move(string, resource, synchronizedCollection, synchronizedCollection2, false);
    }

    protected boolean move(String string, Resource resource, SynchronizedCollection synchronizedCollection, SynchronizedCollection synchronizedCollection2, boolean bl) {
        Resource resource2 = resource;
        Resource resource3 = resource;
        synchronized (resource3) {
            if (!synchronizedCollection.remove(resource)) {
                return false;
            }
            try {
                if (bl) {
                    resource2 = this.resourceFactory.recreateResource(this, resource);
                    resource.clear();
                }
                this.log.log(5, this, string, "", resource2);
                synchronizedCollection2.add(resource2);
                return true;
            }
            catch (Throwable throwable) {
                this.createResources.add(resource2);
                throw new RuntimeException(throwable);
            }
        }
    }

    protected boolean move(SynchronizedCollection synchronizedCollection, SynchronizedCollection synchronizedCollection2) {
        Object object = synchronizedCollection.nextNoWait();
        if (object != null) {
            synchronizedCollection2.add(object);
        }
        return object != null;
    }

    protected boolean recreateResource(String string, Resource resource, SynchronizedCollection synchronizedCollection, SynchronizedCollection synchronizedCollection2) {
        return this.move(string, resource, synchronizedCollection, synchronizedCollection2, true);
    }

    protected void useCreateThread() {
        if (this.createThread != null) {
            this.createThread.end();
        }
        this.createThread = new FeederThread(this.createResources){

            protected void doWork(Object object) throws Exception {
                ResourcePoolBasic.this.guaranteedCreate((Resource)object);
            }
        };
        this.createThread.start();
    }

    protected void useDestroyThread() {
        if (this.destroyThread != null) {
            this.destroyThread.end();
        }
        this.destroyThread = new FeederThread(this.deadResources){

            protected void doWork(Object object) throws Exception {
                Resource resource = (Resource)object;
                if (resource.getRawResource() != null) {
                    ResourcePoolBasic.this.guaranteedDestroy(resource);
                    resource.setRawResource(null);
                }
            }
        };
        this.destroyThread.start();
    }

    protected void useRecycleDestroyThread() {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                try {
                    ResourcePoolBasic.this.useDestroyThread();
                }
                catch (Throwable throwable) {
                    ResourcePoolBasic.this.error(this, throwable);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(timerTask, this.config.getDestroyThreadRecycleTime(), (long)this.config.getDestroyThreadRecycleTime());
    }

    protected void useRecycleThread() {
        for (int i = 1; i <= this.config.getNumberOfRecycleThreads(); ++i) {
            FeederThread feederThread = new FeederThread(this.recycleResources){

                protected void doWork(Object object) throws Exception {
                    ResourcePoolBasic.this.guaranteedRecycle((Resource)object);
                }
            };
            feederThread.start();
            this.recycleThreads.add(feederThread);
        }
    }

    protected void logSizes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(" Resource Pool Statistics:");
        stringBuffer.append("\n\tALLOCATED = ");
        stringBuffer.append(this.allocatedSize());
        stringBuffer.append("\n\tFREE = ");
        stringBuffer.append(this.freeSize());
        stringBuffer.append("\n\tRECYCLE = ");
        stringBuffer.append(this.recycleResources.size());
        stringBuffer.append("\n\tCREATE = ");
        stringBuffer.append(this.createResources.size());
        stringBuffer.append("\n\tDESTROY = ");
        stringBuffer.append(this.deadResources.size());
        stringBuffer.append("\n\tSPARE = ");
        stringBuffer.append(this.spareTokens.size());
        stringBuffer.append("\n\tSIZE = ");
        stringBuffer.append(this.size());
        stringBuffer.append("\n\tCONNECTIONS = ");
        stringBuffer.append(ConnectionFactory.getConnectionCount());
        this.log.log(4, stringBuffer.toString());
    }

    protected void useSizeThread() {
        if (this.sizeThread != null) {
            this.sizeThread.end();
        }
        this.sizeThread = new UniconThread(){

            public void run() {
                while (this.continueRunning) {
                    this.guaranteedSleep();
                    if (!this.continueRunning) continue;
                    ResourcePoolBasic.this.logSizes();
                }
            }
        };
        this.log.log(5, "Starting Size Thread with sleeptime " + this.config.getSizeSleepTime());
        this.sizeThread.setSleepTime(this.config.getSizeSleepTime());
        this.sizeThread.start();
    }

    protected void useTimeoutThread() {
        if (this.timeoutThread != null) {
            this.timeoutThread.end();
        }
        this.timeoutThread = new TimerThread(this.config.getTimeoutSleepTime(), this.allocatedResources){

            protected void doWork(Object object) throws Exception {
                long l;
                Resource resource = (Resource)object;
                long l2 = System.currentTimeMillis();
                if (l2 > (l = resource.getAssignmentTime() + (long)ResourcePoolBasic.this.config.getTimeoutPeriod())) {
                    ResourcePoolBasic.this.guaranteedTimeout((Resource)object);
                }
            }
        };
        this.timeoutThread.start();
    }

    public int recycleResourcesSize() {
        return this.recycleResources.size();
    }

    public int createResourcesSize() {
        return this.createResources.size();
    }

    public int spareSize() {
        return this.spareTokens.size();
    }

    public int destroySize() {
        return this.deadResources.size();
    }

    public void close() {
        this.closeCollection(this.allocatedResources);
        this.closeCollection(this.createResources);
        this.closeCollection(this.deadResources);
        this.closeCollection(this.freeResources);
        this.closeCollection(this.recycleResources);
        this.closeThread(this.createThread);
        this.closeThread(this.destroyThread);
        this.closeThreads(this.recycleThreads);
        this.closeThread(this.sizeThread);
        this.closeThread(this.timeoutThread);
    }

    protected void closeCollection(SynchronizedCollection synchronizedCollection) {
        if (synchronizedCollection == null) {
            return;
        }
        try {
            List list = synchronizedCollection.contents();
            for (int i = 0; i < list.size(); ++i) {
                try {
                    Resource resource = (Resource)list.get(i);
                    synchronizedCollection.remove(resource);
                    resource.destroy();
                    continue;
                }
                catch (Throwable throwable) {
                    ErrorUtils.checkIgnore(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
        }
    }

    protected void closeThreads(Set set) {
        if (set == null) {
            return;
        }
        try {
            ArrayList arrayList = new ArrayList(set);
            for (int i = 0; i < arrayList.size(); ++i) {
                UniconThread uniconThread = (UniconThread)arrayList.get(i);
                set.remove(uniconThread);
                this.closeThread(uniconThread);
            }
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
        }
    }

    protected void closeThread(UniconThread uniconThread) {
        try {
            uniconThread.kill();
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
        }
    }
}

